﻿//
// DeployVideo
//

function deployVideoComponent(contentURL, videoWidth, videoHeight, publishAsVersion, skinURL, cuePoints)
{
	fl.getDocumentDOM().selectNone();
	
	var tl = fl.getDocumentDOM().getTimeline();
	var numElementsBeforeAdd = tl.layers[tl.currentLayer].frames[tl.currentFrame].elements.length;

	if (publishAsVersion >= 8) {
		fl.componentsPanel.addItemToDocument({x:0, y:0}, "FLV Playback - Player 8", "FLVPlayback");
	} else {
		fl.componentsPanel.addItemToDocument({x:0, y:0}, "Media - Player 6 - 7", "MediaPlayback");
				
		if (videoHeight > 0) {
			videoHeight += 70;
		}
		
		if (videoWidth > 0) {
			videoWidth += 20;
		}
	}
	
	var elements = tl.layers[tl.currentLayer].frames[tl.currentFrame].elements;
	if (elements.length > numElementsBeforeAdd) {
		var mediaComponentInstance = elements[elements.length-1];
		mediaComponentInstance.parameters["contentPath"].value = contentURL;
		
		if (publishAsVersion >= 8) {
			mediaComponentInstance.parameters["skin"].value = skinURL;
			mediaComponentInstance.parameters["cuePoints"].value = cuePoints;
		}
		
		if (videoHeight > 0) {
			mediaComponentInstance.height = videoHeight;
		}
		
		if (videoWidth > 0) {
			mediaComponentInstance.width = videoWidth;
		}

		if (videoHeight == 0 && videoWidth == 0) {
			mediaComponentInstance.parameters["autoSize"].value = true;
		}
		
		mediaComponentInstance.selected = true;
		fl.getDocumentDOM().align("vertical center", true);
		fl.getDocumentDOM().align("horizontal center", true);
	}
}

function deployVideoAsProgressiveDownload(contentURL, videoWidth, videoHeight, publishAsVersion, skinURL, cuePoints)
{
	return deployVideoComponent(contentURL, videoWidth, videoHeight, publishAsVersion, skinURL, cuePoints);
}

function deployVideoAsFVSS(contentURL, videoWidth, videoHeight, publishAsVersion, skinURL, cuePoints)
{
	return deployVideoComponent(contentURL, videoWidth, videoHeight, publishAsVersion, skinURL, cuePoints);
}

function deployVideoAsFlashCom(contentURL, videoWidth, videoHeight, publishAsVersion, skinURL, cuePoints)
{
	return deployVideoComponent(contentURL, videoWidth, videoHeight, publishAsVersion, skinURL, cuePoints);
}



